Rem AddGuides.vbs
Rem An InDesign VBScript
Rem
Rem Adds guides around the selected object or objects.
Rem
Rem Choose Visible Bounds to consider the stroke weight of the paths when placing the guides,
Rem or choose Geometric Bounds to ignore the stroke weight when placing the guides
Rem Choose Each Item to position the guides around individual items in the selection,
Rem or Entire Selection to position the guides around the selection as a whole.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem or visit the InDesign scripting user to user forum at http://www.adobeforums.com.
Rem
main
Function main()
	ReDim myObjectList(0)
	Set myInDesign = CreateObject("InDesign.Application.2022")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.Selection.Count <> 0 Then
	        For myCounter = 1 To myInDesign.Selection.Count
	            Select Case TypeName(myInDesign.Selection.Item(myCounter))
	                Case "Rectangle", "Oval", "Polygon", "GraphicLine", "Button", "Group", "TextFrame"
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter)
	            End Select
	        Next
	        If Not (IsEmpty(myObjectList(0))) Then
	            myDisplayDialog myInDesign, myObjectList
	        End If
	    Else
	        MsgBox ("Nothing is selected. Please select an object and try again.")
	    End If
	Else
	    MsgBox ("Please open a document, select an object, and try again.")
	End If
End Function
Function myDisplayDialog(myInDesign, myObjectList)
Set myDialog = myInDesign.Dialogs.Add
myDialog.Name = "AddGuides"
With myDialog.DialogColumns.Add
    With .BorderPanels.Add
            With .DialogColumns.Add
                With .StaticTexts.Add
                    .StaticLabel = "Add Guides at:"
                End With
            End With
            With .DialogColumns.Add
                Set myTopCheckbox = .CheckboxControls.Add
                myTopCheckbox.StaticLabel = "&Top"
                myTopCheckbox.CheckedState = True
                Set myLeftCheckbox = .CheckboxControls.Add
                myLeftCheckbox.StaticLabel = "&Left"
                myLeftCheckbox.CheckedState = True
                Set myBottomCheckbox = .CheckboxControls.Add
                myBottomCheckbox.StaticLabel = "&Bottom"
                myBottomCheckbox.CheckedState = True
                Set myRightCheckbox = .CheckboxControls.Add
                myRightCheckbox.StaticLabel = "&Right"
                myRightCheckbox.CheckedState = True
                Set myXCenterCheckbox = .CheckboxControls.Add
                myXCenterCheckbox.StaticLabel = "&Horizontal Center"
                myXCenterCheckbox.CheckedState = True
                Set myYCenterCheckbox = .CheckboxControls.Add
                myYCenterCheckbox.StaticLabel = "&Vertical Center"
                myYCenterCheckbox.CheckedState = True
                Set myXPointCheckbox = .CheckboxControls.Add
                myXPointCheckbox.StaticLabel = "Path Point Hori&zontal Center"
                myXPointCheckbox.CheckedState = False
                Set myYPointCheckbox = .CheckboxControls.Add
                myYPointCheckbox.StaticLabel = "Path Point Verti&cal Center"
                myYPointCheckbox.CheckedState = False
            End With
    End With
    With .BorderPanels.Add
            With .DialogColumns.Add
                With .StaticTexts.Add
                    .StaticLabel = "Add Guides Around:"
                End With
            End With
            With .DialogColumns.Add
                Set myRangeButtons = .RadiobuttonGroups.Add
                With myRangeButtons
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Each &Object"
                        .CheckedState = True
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "Entire &Selection"
                    End With
                End With
            End With
    End With
    With .BorderPanels.Add
            With .DialogColumns.Add
                With .StaticTexts.Add
                    .StaticLabel = "Guides Based On:"
                End With
            End With
            With .DialogColumns.Add
                Set myBasedOnButtons = .RadiobuttonGroups.Add
                With myBasedOnButtons
                    With .RadiobuttonControls.Add
                        .StaticLabel = "&Geometric Bounds"
                        .CheckedState = True
                    End With
                    With .RadiobuttonControls.Add
                        .StaticLabel = "V&isible Bounds"
                    End With
                End With
            End With
    End With
End With
myReturn = myDialog.Show
If myReturn = True Then
    Rem Get the values from the dialog box.
    myTop = myTopCheckbox.CheckedState
    myLeft = myLeftCheckbox.CheckedState
    myBottom = myBottomCheckbox.CheckedState
    myRight = myRightCheckbox.CheckedState
    myXCenter = myXCenterCheckbox.CheckedState
    myYCenter = myYCenterCheckbox.CheckedState
    myXPoint = myXPointCheckbox.CheckedState
    myYPoint = myYPointCheckbox.CheckedState
    myRange = myRangeButtons.SelectedButton
    myBasedOn = myBasedOnButtons.SelectedButton
    myDialog.Destroy
    If (myTop + myLeft + myBottom + myRight + myXCenter + myYCenter + myXPoint + myYPoint) <> 0 Then
        myAddGuides myInDesign, myTop, myLeft, myBottom, myRight, myXCenter, myYCenter, myRange, myBasedOn, myXPoint, myYPoint, myObjectList
    End If
End If
End Function
Function myAddGuides(myInDesign, myTop, myLeft, myBottom, myRight, myXCenter, myYCenter, myRange, myBasedOn, myXPoint, myYPoint, myObjectList)
    Set myDocument = myInDesign.ActiveDocument
    myOldRulerOrigin = myDocument.ViewPreferences.RulerOrigin
    myDocument.ViewPreferences.RulerOrigin = idRulerOrigin.idSpineOrigin
    Rem Create a layer to hold the guides (if it does not already exist).
    Err.Clear
    On Error Resume Next
    Set myLayer = myDocument.Layers.Item("Guides")
    If Err.Number <> 0 Then
        Set myLayer = myDocument.Layers.Add
        myLayer.Name = "Guides"
        Err.Clear
    End If
    On Error GoTo 0
    'Set mySpread = myInDesign.ActiveWindow.ActiveSpread
    Rem Process the objects in myObjectList.
    For myCounter = 0 To UBound(myObjectList)
        Set myObject = myObjectList(myCounter)
        If myXPoint = True Or myYPoint = True Then
        	myDrawGuidesAtPathPoints myObject, myXPoint, myYPoint, myLayer
        End If
        Rem Use geometric bounds or visible bounds.
        If myBasedOn = 0 Then
            myBounds = myObject.GeometricBounds
        Else
            myBounds = myObject.VisibleBounds
        End If
        Rem If we're at the first object, set up some initial bounding box values.
        If myCounter = 0 Then
            myX1 = myBounds(1)
            myY1 = myBounds(0)
            myX2 = myBounds(3)
            myY2 = myBounds(2)
        End If
        If myRange = 0 Then
            If TypeName(myObject.Parent) = "Page" Or TypeName(myObject.Parent) = "Spread" Then
                Set myPage = myObject.Parent
            Else
                Set myPage = myInDesign.ActiveWindow.ActiveSpread
            End If
            myDrawGuides myPage, myBounds(1), myBounds(0), myBounds(3), myBounds(2), myTop, myLeft, myBottom, myRight, myXCenter, myYCenter, myLayer
        Else
            Rem Compare the bounds values to the stored bounds.
            Rem If a given bounds value is less than (for x1 and y1) or
            Rem greater than (for x2 and y2) the stored value,
            Rem then replace the stored value with the bounds value.
            If myBounds(0) < myY1 Then
                myY1 = myBounds(0)
            End If
            If myBounds(1) < myX1 Then
                myX1 = myBounds(1)
            End If
            If myBounds(2) > myY2 Then
                myY2 = myBounds(2)
            End If
            If myBounds(3) > myX2 Then
                myX2 = myBounds(3)
            End If
        End If
    Next
    If myRange <> 0 Then
        If ((TypeName(myObject.Parent) = "Page") Or (TypeName(myObject.Parent) = "Spread")) Then
            Set myPage = myObject.Parent
        Else
            Set myPage = myInDesign.ActiveWindow.ActiveSpread
        End If
        myDrawGuides myPage, myX1, myY1, myX2, myY2, myTop, myLeft, myBottom, myRight, myXCenter, myYCenter, myLayer
    End If
    myDocument.ViewPreferences.RulerOrigin = myOldRulerOrigin
End Function
Function myDrawGuidesAtPathPoints(myObject, myXPoint, myYPoint, myLayer)
	For myPathCounter = 1 To myObject.Paths.Count
		for myPointCounter = 1 To myObject.Paths.Item(myPathCounter).PathPoints.Count
			If myXPoint = True Then
				myDrawGuide myObject.parent, myObject.Paths.Item(myPathCounter).PathPoints.Item(myPointCounter).Anchor(0), 1, myLayer
			End If
			If myYPoint = True Then
				myDrawGuide myObject.parent, myObject.Paths.Item(myPathCounter).PathPoints.Item(myPointCounter).Anchor(1), 0, myLayer
			End If
		Next
	Next
End Function
Function myDrawGuides(myPage, myX1, myY1, myX2, myY2, myTop, myLeft, myBottom, myRight, myXCenter, myYCenter, myLayer)
    If myTop = True Then
        myDrawGuide myPage, myY1, 0, myLayer
    End If
    If myLeft = True Then
        myDrawGuide myPage, myX1, 1, myLayer
    End If
    If myBottom = True Then
        myDrawGuide myPage, myY2, 0, myLayer
    End If
    If myRight = True Then
        myDrawGuide myPage, myX2, 1, myLayer
    End If
    If myXCenter = True Then
        myDrawGuide myPage, myX1 + ((myX2 - myX1) / 2), 1, myLayer
    End If
    If myYCenter = True Then
        myDrawGuide myPage, myY1 + ((myY2 - myY1) / 2), 0, myLayer
    End If
End Function
Function myDrawGuide(myPage, myLocation, myGuideOrientation, myLayer)
    Set myGuide = myPage.Guides.Add(myLayer)
    If myGuideOrientation = 0 Then
        myGuide.Orientation = idHorizontalOrVertical.idHorizontal
    Else
        myGuide.Orientation = idHorizontalOrVertical.idVertical
    End If
    myGuide.Location = myLocation
End Function

'' SIG '' Begin signature block
'' SIG '' MIIhPgYJKoZIhvcNAQcCoIIhLzCCISsCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' jHahLOEwlafQy944UbD9gGf/9po91RjL1wHTol80VLeg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQCHK5i9aO5k82w+FiDw5C
'' SIG '' dzANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTIw
'' SIG '' MTIxOTAwMDAwMFoXDTIyMTIyMTIzNTk1OVowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKraHbKp
'' SIG '' 7LWhQb1eUijAwzznOPnL0ar6Bh5IyTX0X3Nmx0y/zOPp
'' SIG '' A769ixYCLdufIms+U9xBOpXey6jajunMtomUtqLHkYMN
'' SIG '' DT2jzWOCqLvnwrHjehFxLYwYIt9ymU0VqJHPcIO+0lfA
'' SIG '' s4ZoskzD5OepJsCVjURfwILDS/l51c42dKXqbPmr25vz
'' SIG '' UQBlKIg7JV7JJGj29DQMOeCI9LSY4dAUYsfaEfDx0dcb
'' SIG '' T/oDlUZAH/mGrvFonoqGwLDNNSpWkFauC3ryUlgMJ6if
'' SIG '' JX9iZIrdm6Glo/EvxbsHMzsL2TclgBXoa0mYq4PYgMH1
'' SIG '' 5XYNA9y4x7QNLRmWPpXU+4gnfN0CAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBS5nvze3WzR/65rffm/COInbJUTtzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEALl6DDJXB+ruS0J/n4zd6
'' SIG '' IxqKGcJnnn72tgm50zJjxjqD9f4gMlY5lFA4Dcz9D6ur
'' SIG '' Yc734LqeT9p+oUv2PI4KdFMpSmhdrKLkI8eTK46NHVW8
'' SIG '' U/GZctdsVZR1JvtI1ByrH/DkQS7HTKWwtbyOkKU7lfYK
'' SIG '' HIS+qUso64cM6M2asUym8CdN/3FbwJ9dGJDX9yfMISbX
'' SIG '' oIDfInSnVDD+Z9EnnpsEw9obZwNHaGdd1NJRuPrlwatk
'' SIG '' YdBJuo5kN5/eBMYb95FbK8zZf8e+5FTnEJ0PmxRakjlF
'' SIG '' xh5Zg3CCjiIjr3w/uUkOaa2PjpkNy/vuUYxCuJb53Ca6
'' SIG '' i+n/WMWWjYJLNDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCFAIwghP+AgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAhyuYvWjuZPNsPhYg8OQncw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIBS5fduzRTqw
'' SIG '' 9I0H8A4JAMMLMKwYnas+ofXAPRzxOh1rMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAZkbn94CN
'' SIG '' G7IdImL5tu9bjwSXecfQ8ChARov6czhcBo6FcBR+3OuY
'' SIG '' z4OiUbbsNwI8Lk1sthSIA5ckOqZFuVjQl4uQW8Dmvg1k
'' SIG '' Lr5eYe9yx2s/0lDgaDVt0bgnyn9XQfuIX5LYZjYak4/8
'' SIG '' ivJgakwNkWk6H11Kx9NjpTD7U1ka4H38wbh+jtS7wPVf
'' SIG '' 9GLUyCNz1UnJIKSOYlC29oLEbmnGPpTpC8QADFkgx+Ps
'' SIG '' 2mA8lyrJI5k6etSEvtdK2VulxHHQMnSK3qyChUrzq9cS
'' SIG '' Ndo5fGTLpIF998xMMSJH4+ice8EHl5laT11oQoPDNqdk
'' SIG '' TM4/a5fwzdCxdho0gwB8WBZBWqGCEbMwghGvBgorBgEE
'' SIG '' AYI3AwMBMYIRnzCCEZsGCSqGSIb3DQEHAqCCEYwwghGI
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCCJLyytC3Yw4O4X+LXNPzR3CbTms3Q6+tWY
'' SIG '' xpmc2kk2ogIRANfSX+p4DOZeKV0DTSQOMOQYDzIwMjIw
'' SIG '' NDE4MTkwMzAzWqCCDXwwggbGMIIErqADAgECAhAKekqI
'' SIG '' nsmZQpAGYzhNhpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJ
'' SIG '' BgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
'' SIG '' LjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBS
'' SIG '' U0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcN
'' SIG '' MjIwMzI5MDAwMDAwWhcNMzMwMzE0MjM1OTU5WjBMMQsw
'' SIG '' CQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIElu
'' SIG '' Yy4xJDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAy
'' SIG '' MDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCC
'' SIG '' AgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
'' SIG '' 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFEN
'' SIG '' MQe6Rm7po0tI6IlBfw2y1vmE8Zg+C78KhBJxbKFiJgHT
'' SIG '' zsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFqRUIj
'' SIG '' QVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRS
'' SIG '' Xw9Q3tRZLER0wDJHGVvimC6P0Mo//8ZnzzyTlU6E6XYY
'' SIG '' mJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHVGBS3BEXz
'' SIG '' 4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2u
'' SIG '' fyguwp7gC0vICNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5w
'' SIG '' LOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90QQqvuY4J03Sh
'' SIG '' L7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHX
'' SIG '' L537/M2xwafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP
'' SIG '' 6+SxIXuGZ1h+fx/oK+QUshbWgaHK2jCQa+5vdcCwNiay
'' SIG '' CDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tL
'' SIG '' suK2QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqY
'' SIG '' klHNP8lE54CLKUJy93my3YTqJ+7+fXprAgMBAAGjggGL
'' SIG '' MIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
'' SIG '' ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAE
'' SIG '' GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwHwYDVR0j
'' SIG '' BBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0O
'' SIG '' BBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRT
'' SIG '' MFEwT6BNoEuGSWh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNv
'' SIG '' bS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
'' SIG '' aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGD
'' SIG '' MIGAMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdp
'' SIG '' Y2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9jYWNl
'' SIG '' cnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRH
'' SIG '' NFJTQTQwOTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQw
'' SIG '' DQYJKoZIhvcNAQELBQADggIBAA0tI3Sm0fX46kuZPwHk
'' SIG '' 9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76T
'' SIG '' Ot4qOVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7f
'' SIG '' IyJs1d/2WcuhwupMdsqh3KErlribVakaa33R9QIJT4LW
'' SIG '' pXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
'' SIG '' y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZb
'' SIG '' NZJQfPQXpodkTz5GiRZjIGvL8nvQNeNKcEiptucdYL0E
'' SIG '' IhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiLfmSi
'' SIG '' ZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBV
'' SIG '' eNaY/lRtf3GpSBp43UZ3Lht6wDOK+EoojBKoc88t+dMj
'' SIG '' 8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pIallDrl/q
'' SIG '' +A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW0
'' SIG '' 5rUMopml1xVrNQ6F1uAszOAMJLh8UgsemXzvyMjFjFhp
'' SIG '' r6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBFThIcFClYzG/T
'' SIG '' f8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zM
'' SIG '' bbUNrkdjOEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3
'' SIG '' AhMcMIIGrjCCBJagAwIBAgIQBzY3tyRUfNhHrP0oZipe
'' SIG '' WzANBgkqhkiG9w0BAQsFADBiMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2Vy
'' SIG '' dCBUcnVzdGVkIFJvb3QgRzQwHhcNMjIwMzIzMDAwMDAw
'' SIG '' WhcNMzcwMzIyMjM1OTU5WjBjMQswCQYDVQQGEwJVUzEX
'' SIG '' MBUGA1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMT
'' SIG '' MkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEy
'' SIG '' NTYgVGltZVN0YW1waW5nIENBMIICIjANBgkqhkiG9w0B
'' SIG '' AQEFAAOCAg8AMIICCgKCAgEAxoY1BkmzwT1ySVFVxyUD
'' SIG '' xPKRN6mXUaHW0oPRnkyibaCwzIP5WvYRoUQVQl+kiPNo
'' SIG '' +n3znIkLf50fng8zH1ATCyZzlm34V6gCff1DtITaEfFz
'' SIG '' sbPuK4CEiiIY3+vaPcQXf6sZKz5C3GeO6lE98NZW1Oco
'' SIG '' LevTsbV15x8GZY2UKdPZ7Gnf2ZCHRgB720RBidx8ald6
'' SIG '' 8Dd5n12sy+iEZLRS8nZH92GDGd1ftFQLIWhuNyG7QKxf
'' SIG '' st5Kfc71ORJn7w6lY2zkpsUdzTYNXNXmG6jBZHRAp8By
'' SIG '' xbpOH7G1WE15/tePc5OsLDnipUjW8LAxE6lXKZYnLvWH
'' SIG '' po9OdhVVJnCYJn+gGkcgQ+NDY4B7dW4nJZCYOjgRs/b2
'' SIG '' nuY7W+yB3iIU2YIqx5K/oN7jPqJz+ucfWmyU8lKVEStY
'' SIG '' dEAoq3NDzt9KoRxrOMUp88qqlnNCaJ+2RrOdOqPVA+C/
'' SIG '' 8KI8ykLcGEh/FDTP0kyr75s9/g64ZCr6dSgkQe1CvwWc
'' SIG '' ZklSUPRR8zZJTYsg0ixXNXkrqPNFYLwjjVj33GHek/45
'' SIG '' wPmyMKVM1+mYSlg+0wOI/rOP015LdhJRk8mMDDtbiiKo
'' SIG '' wSYI+RQQEgN9XyO7ZONj4KbhPvbCdLI/Hgl27KtdRnXi
'' SIG '' YKNYCQEoAA6EVO7O6V3IXjASvUaetdN2udIOa5kM0jO0
'' SIG '' zbECAwEAAaOCAV0wggFZMBIGA1UdEwEB/wQIMAYBAf8C
'' SIG '' AQAwHQYDVR0OBBYEFLoW2W1NhS9zKXaaL3WMaiCPnshv
'' SIG '' MB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiuHA9P
'' SIG '' MA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEF
'' SIG '' BQcDCDB3BggrBgEFBQcBAQRrMGkwJAYIKwYBBQUHMAGG
'' SIG '' GGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggrBgEF
'' SIG '' BQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29t
'' SIG '' L0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcnQwQwYDVR0f
'' SIG '' BDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmwwIAYD
'' SIG '' VR0gBBkwFzAIBgZngQwBBAIwCwYJYIZIAYb9bAcBMA0G
'' SIG '' CSqGSIb3DQEBCwUAA4ICAQB9WY7Ak7ZvmKlEIgF+ZtbY
'' SIG '' IULhsBguEE0TzzBTzr8Y+8dQXeJLKftwig2qKWn8acHP
'' SIG '' HQfpPmDI2AvlXFvXbYf6hCAlNDFnzbYSlm/EUExiHQwI
'' SIG '' gqgWvalWzxVzjQEiJc6VaT9Hd/tydBTX/6tPiix6q4XN
'' SIG '' Q1/tYLaqT5Fmniye4Iqs5f2MvGQmh2ySvZ180HAKfO+o
'' SIG '' vHVPulr3qRCyXen/KFSJ8NWKcXZl2szwcqMj+sAngkSu
'' SIG '' mScbqyQeJsG33irr9p6xeZmBo1aGqwpFyd/EjaDnmPv7
'' SIG '' pp1yr8THwcFqcdnGE4AJxLafzYeHJLtPo0m5d2aR8XKc
'' SIG '' 6UsCUqc3fpNTrDsdCEkPlM05et3/JWOZJyw9P2un8WbD
'' SIG '' Qc1PtkCbISFA0LcTJM3cHXg65J6t5TRxktcma+Q4c6um
'' SIG '' AU+9Pzt4rUyt+8SVe+0KXzM5h0F4ejjpnOHdI/0dKNPH
'' SIG '' +ejxmF/7K9h+8kaddSweJywm228Vex4Ziza4k9Tm8heZ
'' SIG '' Wcpw8De/mADfIBZPJ/tgZxahZrrdVcA6KYawmKAr7ZVB
'' SIG '' tzrVFZgxtGIJDwq9gdkT/r+k0fNX2bwE+oLeMt8EifAA
'' SIG '' zV3C+dAjfwAL5HYCJtnwZXZCpimHCUcr5n8apIUP/JiW
'' SIG '' 9lVUKx+A+sDyDivl1vupL0QVSucTDh3bNzgaoSv27dZ8
'' SIG '' /DGCA3YwggNyAgEBMHcwYzELMAkGA1UEBhMCVVMxFzAV
'' SIG '' BgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
'' SIG '' aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2
'' SIG '' IFRpbWVTdGFtcGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaX
'' SIG '' nTANBglghkgBZQMEAgEFAKCB0TAaBgkqhkiG9w0BCQMx
'' SIG '' DQYLKoZIhvcNAQkQAQQwHAYJKoZIhvcNAQkFMQ8XDTIy
'' SIG '' MDQxODE5MDMwM1owKwYLKoZIhvcNAQkQAgwxHDAaMBgw
'' SIG '' FgQUhQjzhlFcs9MHfba0t8B/G0peQd4wLwYJKoZIhvcN
'' SIG '' AQkEMSIEIDs1GoByS4lWHsI3S1B4Pzp4qekahkfcIiHc
'' SIG '' mJuJTxJ5MDcGCyqGSIb3DQEJEAIvMSgwJjAkMCIEIJ2m
'' SIG '' kBXDScbBiXhFujWCrXDIj6QpO9tqvpwr0lOSeeY7MA0G
'' SIG '' CSqGSIb3DQEBAQUABIICAGvs743/JBa9EzeN8ZEikCwv
'' SIG '' ZPGseE7m/tS/86SpHhvuMeCAXcVAUMS/VPwQThLVoIWm
'' SIG '' nJ5iyfl18dQiKqfKR2hTF6OwRplIX/JQ+ma9DFutlS7a
'' SIG '' vAqxn3Oj0+eAbz6kc6eVV691SGk3FUPwQBLM4uPEv1/+
'' SIG '' lYF1Bw5TmTYPGQnmL0nU8MtE9B5YEAzUOvt+mGHXgILm
'' SIG '' AYIBfKXBreyacko1aaGpqQwb9T+hyd4YZftDAkvAYZDK
'' SIG '' xtLURONvh8rTJLS3abo1+lEy9ZdXwFx5Cvmr8vb1CU6B
'' SIG '' NtvyO3c2qkkrm96jr/RKqgQ9nWoTsUhMPHzYfBwt/EiI
'' SIG '' VBVMLqVG1dnfxmowIZmWp0FEr5xOfnB5TgN8jdRMYfge
'' SIG '' 5ubQz0xioJEv6229nWXMqovFhlke+Bp15vZcNLPePWVp
'' SIG '' SsyT1PG6guWUwJEj6qFFAoWNGykan0hy2sc/HC/O47c/
'' SIG '' skf6dQuJKMjdzIgchSAyLNlZ1KJtThOFbwZo+8h7R6HH
'' SIG '' V3pChhX3oaN0cxDeUlrLCpua2AGYtWhUyjVbLn7q9tfU
'' SIG '' i5FXbnrxE6Z+PFbxP+0cad1fS+YFCr2ISCq4jkPD779R
'' SIG '' kbg3CoHnvmSmO0jQLa1M3GfUAhurwW2xhaFzBh2ZforT
'' SIG '' fSQVjRGLH7uBK8BZ7YsZHepKMlvX+TpA2yFFf/JSK/uj
'' SIG '' End signature block
